using HIPS.Client.Proxy;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.ModelInterface.HpiiSearch;

namespace HIPS.Web.Data.Hips.HpiiSearch
{
    public class HpiiSearchService : IHpiiSearchService
    {
        private HpiiProxy proxy = new HpiiProxy("HpiiEndPoint");
        
        public HpiiQueryResponse SearchByIdentifier(HpiiIdentifierQuery query, UserDetails operatingUser)
        {
            return proxy.HpiiValidation(query, operatingUser);
        }

        public HpiiQueryResponse SearchByDemographic(HpiiDemographicQuery query, UserDetails operatingUser)
        {
            return proxy.HpiiDemographicSearch(query, operatingUser);
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (proxy != null)
            {
                proxy.DisposeSafely();
                proxy = null;
            }
        }
    }
}